Attribute VB_Name = "MdlDld"
Option Explicit

Declare Function DldCalc Lib "dld.dll" (ByVal Point As Long, ByVal Cf As Double, ByVal f1 As Double, ByVal f2 As Double, ByRef R As Single, ByRef X As Single, ByRef CI As Single, ByRef DF As Single) As Long

Type DldPack_t
    lev As Single       ''Output level (dBm)
    tim As Single       ''Settling time (sec)
    rbw As Single       ''RBW (Hz)
End Type

Public DldCiBuf(0 To 800) As Single
Public DldDfBuf(0 To 800) As Single

''Internal local variable=====================================================
Private Stim(0 To 1600) As SourSeg
Private dldpt As Long, dldf1 As Double, dldf2 As Double
Private re(0 To 1600) As Single, im(0 To 1600) As Single
''======================================================================

''--- Saves current setting ---
Private Sub save(PID As Long, ByRef Ch As Long, ByRef cont As Long)
    Call QryMeasAct(PID, Ch)
    Call QryInitCont(PID, cont)

End Sub
''--- Recalls setting ---
Private Sub load(PID As Long, Ch As Long, cont As Long)
    Call BisMeasAct(PID, Ch)
    Call BisInitCont(PID, cont)

End Sub

''----------------------------------------------------------------------------
''  Function name  FDldSetup
''  Function    FSetup for DLD measurement
''  Argument    FPID As Long           Packet ID (specify value obtained by BisOpenPacket)
''            Nl As Long            Number of levels (1 to 800)
''            Freq As Double        DLD center frequency (Hz)
''            Span As Double        DLD span (ppm)
''            Pac() As DldPack_t    Level, settling, RBW
''            Ch As Long            Channels used (1 to 4)
''  Return value  FSuccessful (True) / Error (False)
''  Functional descriptionsFSets the conditions for the DLD measurement to the specified channel.
''----------------------------------------------------------------------------
Function DldSetup(PID As Long, Nl As Long, Freq As Double, Span As Double, Pac() As DldPack_t, Ch As Long)
    Dim X As Double
    Dim tmp As Single
    Dim dum As SourSeg
    Dim i As Long
    Dim act As Long
    Dim cont As Long
    
    DldSetup = False
    dldpt = 0
    
    If Ch < 1 Or 4 < Ch Then
        MsgBox "Misspecification of channel\n( Ch = " & CStr(Ch) & " )"
        Exit Function
    End If
  
    ''Checking the number of levels
    If Nl < 1 Or Nl > 800 Then
        MsgBox "Misspecification of the number of levels\n( Nl = " & CStr(Nl) & " )"
        Exit Function
    End If
    ''Checking the level and RBW values
    For i = 0 To Nl - 1
        tmp = Pac(i).lev
        If tmp < -43 Or 21 < tmp Then
            MsgBox "Misspecification of level\n( Lev(" & CStr(i) & ") = " & CStr(tmp) & " )"
            Exit Function
        End If
        tmp = Pac(i).rbw
        If tmp < 10 Or 15000 < tmp Then
            MsgBox "Misspecification of RBW\n( Rbw(" & CStr(i) & ") = " & CStr(tmp) & " )"
            Exit Function
        End If
    Next i
    ''Checking frequency value
    If Freq < 10000# Or 300000000# < Freq Then
        MsgBox "Misspecification of frequency\n( Freq = " & CStr(Freq) & " )"
        Exit Function
    End If
    If Span < 0.01 Then
        MsgBox "Misspecification of span\n( Span = " & CStr(Span) & " )"
        Exit Function
    End If
    X = Freq * Span * 0.0000005
    dldf1 = Freq - X: dldf2 = Freq + X

    ''Rounding-off to frequency setting resolution (0.1 Hz)
    If 2147483647 < dldf1 * 10 Then
        dldf1 = CDbl(CLng(dldf1 + 0.05))
    Else
        dldf1 = CDbl(CLng(dldf1 * 10)) / 10
    End If
    
    If 2147483647 < dldf2 * 10 Then
        dldf2 = CDbl(CLng(dldf2 + 0.05))
    Else
        dldf2 = CDbl(CLng(dldf2 * 10)) / 10
    End If
    

    If dldf1 < 10000# Or 300000000# < dldf2 Then
        MsgBox "Misspecification of frequency\n( F1=" & CStr(dldf1) & " , F2=" & CStr(dldf2) & " )"
        Exit Function
    End If

    ''Segment creation
    For i = 0 To Nl - 1
        dum.dblFreq1 = dldf1
        dum.dblFreq2 = dldf1
        dum.lngFmode = BIS_FREQ_LIN
        dum.lngFtype = BIS_FREQ_STRSTP
        dum.lngPntN = 1
        dum.sngPow1 = Pac(i).lev
        dum.sngPow2 = Pac(i).lev
        dum.sngRbw = Pac(i).rbw
        dum.sngStime = Pac(i).tim
        Stim(i * 2) = dum
        dum.dblFreq1 = dldf2
        dum.dblFreq2 = dldf2
        Stim(i * 2 + 1) = dum
    Next i
    
    Call save(PID, act, cont)
    
    ''Changing measurement channel
    Call BisMeasAct(PID, Ch)

    ''Setting sweep conditions
    Call BisSourSeg(PID, Stim(0), LenB(dum) * Nl * 2)

    ''Setting Z conversion mode
    Call BisCalcTranImpType(PID, BIS_CONV_ZTRANS)
    
    Call load(PID, act, cont)
    
    dldpt = Nl
    DldSetup = True

End Function

''----------------------------------------------------------------------------
''  Function name  FDldSweep
''  Function    FExecuting DLD measurement
''  Argument    FPID As Long           Packet ID (specify value obtained by BisOpenPacket)
''            Cf As Double          DLD center frequency (Hz)
''            Ch As Long            Channels used (1 to 4)
''  Return value  FSuccessful (True) / Error (False)
''  Functional descriptionsFStarts the DLD measurement and stores the result in the variables below:
''              DldCiBuf()  CI value ()
''              DldDfBuf()   f value (Hz) (difference from Cf argument)
''----------------------------------------------------------------------------
Function DldSweep(PID As Long, Cf As Double, Ch As Long)
    Dim stat&, pt&, tr&
    Dim act As Long
    Dim cont As Long
    
    DldSweep = False
    If Ch < 1 Or 4 < Ch Then Exit Function
    If dldpt < 1 Then Exit Function
    
    Call save(PID, act, cont)
    
    ''Changing measurement channel
    Call BisMeasAct(PID, Ch)
    ''Single sweep mode
    Call BisInitCont(PID, 0&)
    ''Sweep trigger
    Call BisInitImm(PID)
    ''Waiting for completion of sweep
    Do
        DoEvents
        If QryStatOper(PID, stat&) <> 0 Then Exit Do
    Loop While (stat& <> 0)
    ''Measured data acquisition
    tr& = (Ch - 1) * 1024
    pt& = (dldpt * 2) - 1
    Call QryTracData(PID, BIS_TRAC1_UDT_RE + tr&, 0, pt&, re(0))
    Call QryTracData(PID, BIS_TRAC1_UDT_IM + tr&, 0, pt&, im(0))
    ''DLD calculation
    Call DldCalc(dldpt, Cf, dldf1, dldf2, re(0), im(0), DldCiBuf(0), DldDfBuf(0))
    
    Call load(PID, act, cont)
    
    DldSweep = True

End Function

